# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDHistoryUtils(SDAPIObject):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDHistoryUtils
        """
        super(SDHistoryUtils, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def newTransaction(name : str) -> None:
        """
        Create a new undo transaction

        :param name: The transaction name
        """
        _res = sd.getContext().SDHistoryUtils_newTransaction(ctypes.create_string_buffer(name.encode('utf-8')))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None

    @staticmethod
    def commitTransaction() -> None:
        """
        Commit the current transaction

        """
        _res = sd.getContext().SDHistoryUtils_commitTransaction()
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return None
    # Manually written code patched in by IPA begins
    class UndoGroup(object):
       def __init__(self, name : str):
           self.__name = name

       def __enter__(self):
           SDHistoryUtils.newTransaction(self.__name)
           return self

       def __exit__(self, exc_type, exc_val, exc_tb):
           SDHistoryUtils.commitTransaction()
    # Manually written code patched in by IPA ends

